package ftp;

import java.io.File;
import java.io.FileInputStream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;




public class CommandeGET extends Commande {

	public CommandeGET(PrintStream ps, String commandeStr) {
		super(ps, commandeStr);
	}

	@Override
	public void execute() {
		// server details
		
		// Si la commande n'a pas d'argument, envoyer un message d'erreur.
		if (commandeArgs.length == 0)
		{
			System.out.println("-> GET sans argument");
			ps.println("2 La commande doit contenir un nom de fichier du répertoire actuel.");
			return;
		}
		
        int port = 8766;
        
        // Définition du fichier à envoyer.
        File fileToSend = new File(CommandExecutor.currentFile+"\\"+commandeArgs[0]); // file to send
        
        // Si le fichier à envoyer n'existe pas, envoyer un message d'erreur.
        if(!fileToSend.exists()) {
        	ps.println("2 Le fichier n'existe pas");
        	return;
        }
        
        // Si le "fichier" à envoyer est un dossier, envoyer un message d'erreur.
        if(fileToSend.isDirectory()) {
        	ps.println("2 Impossible de transférer un dossier");
        	return;
        }
        
        // create socket and streams
        try (ServerSocket serverSocket = new ServerSocket(port)) {
            
        	// Envoi d'un message au client pour prévénir que le serveur est prêt.
            ps.println("1 Serveur lancer ecoute sur le port : ");

                Socket clientSocket = serverSocket.accept();
                System.out.println("Client connected: " + clientSocket.getInetAddress());
                
                // create streams for sending file
                try (InputStream in = new FileInputStream(fileToSend);
                     OutputStream out = clientSocket.getOutputStream()) {
                    
                    // send file name
                    byte[] fileNameBytes = fileToSend.getName().getBytes();
                    out.write(fileNameBytes.length);
                    out.write(fileNameBytes);
                    
                    // send file contents
                    byte[] buffer = new byte[1024];
                    int bytesRead;
                    while ((bytesRead = in.read(buffer)) > 0) {
                        out.write(buffer, 0, bytesRead);
                    }
                    System.out.println("1 Transfert de fichier complet");
                    ps.println("1 Transfert de fichier complet");
                } catch (IOException e) {
                    System.err.println(e);
                }
                
                clientSocket.close();
                ps.println("0 Deconnexion du serveur");
                System.out.println("Client disconnected: " + clientSocket.getInetAddress());
            
            
        } catch (IOException e) {
            System.err.println(e);
        }
   
	}
	

}